﻿//Sebastan Schimdt Mat.NR.: 754422

package
{   //Import
	import flash.display.*;
	import flash.display.SimpleButton;
	import flash.text.TextField;
	import flash.media.Sound;
	import flash.media.SoundMixer;
	import flash.media.SoundChannel;
	import flash.media.SoundLoaderContext;
	import flash.media.SoundTransform;
	import flash.net.URLRequest;
	import flash.events.Event;
	import flash.events.ProgressEvent;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	import flash.utils.ByteArray;
	
	public class Player extends MovieClip
	{	//Klassenvariablen
		private const ZWISCHENSPEICHER_TIME:int = 3000; //3 sec verzögerung
		private var tracks:Array = ["Song01.mp3","Song02.mp3","Song03.mp3","Song04.mp3","Song05.mp3","Song06.mp3","Song07.mp3","Song08.mp3","Song09.mp3",
									"Song10.mp3","Song11.mp3","Song12.mp3"];//Playlist 
		private var aktuellerIndex:int = 0;//aktuell gespielter song im array
		private var aktuellerSound:Sound; // Aktueller titel
		private var aktuellerKanal:SoundChannel; //aktuelle titel informationen
		private var sBuffer:SoundLoaderContext = new SoundLoaderContext(ZWISCHENSPEICHER_TIME); //titel start verzögerung
		private var aktuellesVolume:Number = 1; //lautstärke
		private var abspielen:Boolean = false;// zustand des players
		private var pausiert:Boolean = false;// -"-
		private const BALKEN_WIDTH:int = 260;  // titel fortschrittsanzeige (breite)
		private var sProzentGeladen:Number;// bereits gestreamter anteil des songs
		private var sLaenge:int;//titel länge
		private var sPosition:int;//position im titel
		private const SLIDER_VOL_X:int = 73;//lautstärkeregler x position
		private const SLIDER_VOL_Y:int = 90;//lautstärkeregler y position
		private const SLIDER_DRAG_WIDTH:int = 84;//länge der Lautstärkenleiste
		private var bytes:ByteArray = new ByteArray();//array zum speichern des frequenzganges
		private var posDotX:int = 86;//x position des ersten punktes im spektrum
		private var posDotY:int = 48;//y position -"-
		private var arryDots:Array = [];//array der 64 spektrumpunkte
		
		//Konstruktor
		public function Player()
		{
			drawDots();  
			trackZuruecksetzten();
			spieleTrack(aktuellerIndex);
			steuerung();
			
		}
		// Stellt player auf ausgangsposition
		private function trackZuruecksetzten():void
		{
			title_txt.text = "";
			aktuellerSound = new Sound();
			aktuellerSound.addEventListener(Event.ID3, onID3);//eventlistener auf die titel informationen des tracks
			aktuellerSound.addEventListener(ProgressEvent.PROGRESS, onProgress);
			positionBar_mc.width = 0;
			updateTime(0);
			teller_mc.x = 23;
			levelleft_mc.x = 40;
			levelright_mc.x = 228;
			
			//stellt alle 64 punkte des soundspektrums in ausgansposition
			for(var v:int = 0; v < 64; v++)
			{
				var sDot:dot = arryDots[v];
				sDot.height = 1;
			}
		}
		
		//Spielt den track
		private function spieleTrack(index:int):void
		{	//falls kein eventlistener vorhanden (Player-Start) wird diese hinzugefügt
			if(!hasEventListener(Event.ENTER_FRAME))
			{
				addEventListener(Event.ENTER_FRAME, onEnterFrame);
			}
			//läd song aus dem Track array an übergebener stelle und puffert diesen 
			aktuellerSound.load(new URLRequest(tracks[index]), sBuffer);
			aktuellerKanal = aktuellerSound.play();//startet song
			aktuellerKanal.addEventListener(Event.SOUND_COMPLETE, onSoundComplete);//reagiert wenn song durchgelaufen
			abspielen = true;
			title_txt.text = (aktuellerIndex+1)+". " + tracks[index];//schreibt titelnummer und dateinamen in textfeld
			setVolume(aktuellesVolume);
		}	
		
		private function onID3(evt:Event):void
		{
			title_txt.text = (aktuellerIndex+1)+". " + aktuellerSound.id3.artist + " - " + aktuellerSound.id3.songName;//übergibt aktuelle titelinformationen an textfeld
		}
		//ladefortschritt
		private function onProgress(evt:ProgressEvent):void
		{
			sProzentGeladen = evt.bytesLoaded/evt.bytesTotal; //errechnet den geladennen teil des songs (wert zwischen 0-1) 
			loadingBar_mc.width = BALKEN_WIDTH*sProzentGeladen;//überträgt fortschritt an die breiten eigenschaft des ladebalkens
		}
		//Aufruf pro frame
		private function onEnterFrame(evt:Event):void
		{
			sLaenge = aktuellerSound.length;
			sPosition =aktuellerKanal.position;
			//Titelfortschritt
			if(sProzentGeladen > 0)
			{
				sLaenge /= sProzentGeladen;
				positionBar_mc.width = BALKEN_WIDTH*sPosition/sLaenge;
				updateTime(sPosition);
				drawSpectrum();
			}
			//Lautstärken anzeige (Lautsprecher)
			if(!pausiert)
			{
				teller_mc.x = 19 + Math.round(5 * aktuellerKanal.leftPeak);//boxenteller bewegt sich bei ausschlag zwischen 0 und 5 pixel nach rechts
				levelleft_mc.x = 40 + Math.round(24 * aktuellerKanal.leftPeak);
				teller2_mc.x = 258 - Math.round(5 * aktuellerKanal.rightPeak);
				levelright_mc.x = 228 - Math.round(24 * aktuellerKanal.rightPeak);//spektrumsmaske wird um 0 bis 24 pixel nach links verschoben 
			}
		}
		//zeitanzeige
		private function updateTime(pos:int):void
		{
			var cMinutes:int = Math.floor(pos/1000/60);//errechnet vergangende min
			var cSeconds:int = Math.floor(pos/1000)%60;//übrige sekunden 
			var mString:String = (cMinutes < 10) ? "0"+cMinutes : cMinutes.toString();//ausgabe der minuten bei wert zwischen 0 und 9 mit führender 0
			var sString:String = (cSeconds < 10) ? "0"+cSeconds : cSeconds.toString();
			time_txt.text = mString + ":" + sString;//übergabe der werte ans textfeld
		}
		//nach vollständig durchölaufendem titel
		private function onSoundComplete(evt:Event):void
		{
			playNext();
		}
		//nächster titel
		private function playNext():void
		{
			stopSound();
			aktuellerIndex = (aktuellerIndex < tracks.length-1) ? ++aktuellerIndex : 0; //wenn weitere titel im array dann zum nächsten ansonsten zum ersten
			spieleTrack(aktuellerIndex);
		}
		//titel stoppen
		private function stopSound():void
		{
			removeEventListener(Event.ENTER_FRAME, onEnterFrame);//entfernen des onEnterFrame Event-Listener
			aktuellerKanal.stop();//stoppt musik
			trackZuruecksetzten();
			pausiert = abspielen = false;
		}
		//Button initalisieren
		private function steuerung():void
		{
			stop_btn.addEventListener(MouseEvent.CLICK, onClick);//aufruf der onClick methode bei klick auf button
			play_btn.addEventListener(MouseEvent.CLICK, onClick);
			pause_btn.addEventListener(MouseEvent.CLICK, onClick);
			next_btn.addEventListener(MouseEvent.CLICK, onClick);
			prev_btn.addEventListener(MouseEvent.CLICK, onClick);
			sliderVolume_mc.addEventListener(MouseEvent.MOUSE_DOWN, dragVolume);//wenn gedrückt
			sliderVolume_mc.addEventListener(MouseEvent.MOUSE_UP, dropVolume);// wenn losgelassen 
			sliderVolume_mc.buttonMode = true;
			stage.addEventListener(MouseEvent.MOUSE_UP, dropVolume);
		}
		//auswertung des gerückten buttons
		private function onClick(evt:MouseEvent):void
		{
			switch(evt.target)
			{
				case stop_btn: stopSound(); break;
				case play_btn:
					if(pausiert) pausePlay();//pausiert
					else if(!abspielen) spieleTrack(aktuellerIndex);//noch nich begonnen
					else stopSound(), spieleTrack(aktuellerIndex);//abspielt
					break;
				case pause_btn: if(abspielen) pausePlay(); break;
				case next_btn: playNext(); break;
				case prev_btn: playPrev(); break;
			}
		}
		//pausieren
		private function pausePlay():void
		{
			if(!pausiert)
			{
				aktuellerKanal.stop();
			}
			else
			{
				aktuellerKanal = aktuellerSound.play(sPosition);
				aktuellerKanal.addEventListener(Event.SOUND_COMPLETE, onSoundComplete);
			}
			pausiert = !pausiert;
		}
		//vorheriger titel
		private function playPrev():void
		{
			stopSound();
			aktuellerIndex = (aktuellerIndex > 0) ? --aktuellerIndex : tracks.length-1;//wenn kein vorheriger titel dann der letzte
			spieleTrack(aktuellerIndex);
		}
		//lautstärkeregler bewegen 
		private function dragVolume(evt:MouseEvent):void
		{
			var tRect:Rectangle = new Rectangle(SLIDER_VOL_X,SLIDER_VOL_Y,SLIDER_DRAG_WIDTH, 0);//leeres rechteck mit startkoordinaten x, y der breite der lautstärkenleiste und der höhe 0 
			sliderVolume_mc.startDrag(false, tRect);//lässt sich verschieben
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onDragVolume);//überwacht komplette bühne
		}
		//beim looslassen des sliders
		private function dropVolume(evt:MouseEvent=null):void
		{
			sliderVolume_mc.stopDrag();//stoppt bewegung
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, onDragVolume);//entfernt listener
		}
		//Lautstärken errechnen
		private function onDragVolume(evt:MouseEvent):void
		{
			setVolume((sliderVolume_mc.x - SLIDER_VOL_X) / SLIDER_DRAG_WIDTH);//position bestimmt lautstärke
		}
		//ändert lautstärke
		private function setVolume(vol:Number):void
		{
			aktuellesVolume = vol;
			aktuellerKanal.soundTransform = new SoundTransform(aktuellesVolume);
		}
		//zeichnet spektrumpunkte und schreibt Movieclips in array
		private function drawDots():void
		{
			for(var m:int = 0; m <64; m++)
			{
				var sDot:dot = new dot();
			    arryDots[m] = sDot;
				sDot.x = posDotX;
				sDot.y = posDotY;
				addChild(sDot);//fügt pixel der bühne hinzu
				posDotX += 2;//verschiebt nächsten punkt um 2 pixel nach rechts
			}
		}
		//zeichnet spektrum
		public function drawSpectrum():void
		{
			SoundMixer.computeSpectrum( bytes, true, 1 );	//schreibt je 256 floatwerte pro soundkanal in ein array	
			var q:int = 0;//aktueller spektrenpixel
			for(var k:int = 0; k <255; k++)//durchläuft ersten 256 felder des arrays
			{
				if(k%4==0)//bei jedem 4ten 
				{
				var sDot:dot = arryDots[q];
				sDot.height = bytes.readFloat()*30;//neue höhe des pixels zwischen 1 und 30
				q++;//nächster pixel
				}
				else
				{
					trace(bytes.readFloat()*30);
				}
			}
		}
	}
}